//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
    char name[100];
    int account_number;
    float balance;
    time_t timestamp;
} customer;

void generate_timestamp(customer* c) {
    time_t now = time(NULL);
    c->timestamp = now;
}

void deposit(customer* c, float amount) {
    c->balance += amount;
    printf("Deposit of %.2f made by %s at %s\n", amount, c->name, ctime(&c->timestamp));
}

void withdraw(customer* c, float amount) {
    if (c->balance >= amount) {
        c->balance -= amount;
        printf("Withdrawal of %.2f made by %s at %s\n", amount, c->name, ctime(&c->timestamp));
    } else {
        printf("Insufficient funds\n");
    }
}

void check_balance(customer* c) {
    printf("Current balance of %s is %.2f\n", c->name, c->balance);
}

int main() {
    customer c1 = {"John Doe", 123456, 1000.00};
    generate_timestamp(&c1);
    deposit(&c1, 500.00);
    check_balance(&c1);
    withdraw(&c1, 200.00);
    check_balance(&c1);

    customer c2 = {"Jane Smith", 789012, 5000.00};
    generate_timestamp(&c2);
    deposit(&c2, 1000.00);
    check_balance(&c2);
    withdraw(&c2, 3000.00);
    check_balance(&c2);

    return 0;
}