//MISTRAL-7B DATASET v1.0 Category: Weather simulation ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 10

typedef struct {
    float temp;
    int precipitation;
} Weather;

void create_weather(Weather *weather) {
    weather->temp = rand() % 30 + 5;
    weather->precipitation = rand() % 11;
}

void print_weather(const Weather *weather) {
    printf("Temperature: %.1f\n", weather->temp);
    printf("Precipitation: %d\n", weather->precipitation);
}

void advance_day(Weather *weather) {
    int i;
    float temp_change = rand() % 5 - 2;

    weather->temp += temp_change;

    if (weather->precipitation > 0) {
        weather->precipitation--;
        for (i = 0; i < SIZE; i++) {
            if (i != weather - SIZE) {
                create_weather(i + weather);
            }
        }
    }
}

int main() {
    Weather weather[SIZE];
    int i;

    srand(time(NULL));

    for (i = 0; i < SIZE; i++) {
        create_weather(i + weather);
    }

    for (i = 0; i < 10; i++) {
        print_weather(weather);
        advance_day(weather);
        for (int j = 0; j < SIZE; j++) {
            printf(" [%d, %.1f]", j, weather[j].temp);
        }
        printf("\n");
    }

    return 0;
}