//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: complete
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define NUM_GHOULS 5
#define GHOUL_SPEED 2
#define GHOUL_DELAY 0.5

// Define the ghoul structure
typedef struct ghoul
{
    char name[20];
    int x, y;
    time_t timer;
} ghoul;

// Create an array of ghouls
ghoul ghouls[NUM_GHOULS];

// Initialize the ghouls
void initializeGhouls()
{
    for (int i = 0; i < NUM_GHOULS; i++)
    {
        ghouls[i].x = rand() % 10;
        ghouls[i].y = rand() % 10;
        ghouls[i].timer = time(NULL) + GHOUL_DELAY;
    }
}

// Move the ghouls
void moveGhouls()
{
    for (int i = 0; i < NUM_GHOULS; i++)
    {
        time_t now = time(NULL);
        if (now >= ghouls[i].timer)
        {
            ghouls[i].x = rand() % 10;
            ghouls[i].y = rand() % 10;
            ghouls[i].timer = now + GHOUL_DELAY;
        }
    }
}

// Print the ghouls
void printGhouls()
{
    for (int i = 0; i < NUM_GHOULS; i++)
    {
        printf("Ghoul: %s at (%d, %d)\n", ghouls[i].name, ghouls[i].x, ghouls[i].y);
    }
}

int main()
{
    initializeGhouls();
    moveGhouls();
    printGhouls();

    return 0;
}