//GEMINI-pro DATASET v1.0 Category: QR code generator ; Style: introspective
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

#define QR_CODE_SIZE 21
#define QR_CODE_BORDER 4

typedef struct {
    uint8_t data[QR_CODE_SIZE * QR_CODE_SIZE];
    uint8_t mask;
} qr_code_t;

static void qr_code_init(qr_code_t *qr_code) {
    memset(qr_code->data, 0, sizeof(qr_code->data));
    qr_code->mask = 0;
}

static void qr_code_set_bit(qr_code_t *qr_code, int x, int y, bool bit) {
    if (x < 0 || x >= QR_CODE_SIZE || y < 0 || y >= QR_CODE_SIZE) {
        return;
    }

    if (bit) {
        qr_code->data[y * QR_CODE_SIZE + x] |= 1 << qr_code->mask;
    } else {
        qr_code->data[y * QR_CODE_SIZE + x] &= ~(1 << qr_code->mask);
    }
}

static bool qr_code_get_bit(qr_code_t *qr_code, int x, int y) {
    if (x < 0 || x >= QR_CODE_SIZE || y < 0 || y >= QR_CODE_SIZE) {
        return false;
    }

    return qr_code->data[y * QR_CODE_SIZE + x] & (1 << qr_code->mask);
}

static void qr_code_print(qr_code_t *qr_code) {
    for (int y = 0; y < QR_CODE_SIZE; y++) {
        for (int x = 0; x < QR_CODE_SIZE; x++) {
            printf("%d ", qr_code_get_bit(qr_code, x, y));
        }
        printf("\n");
    }
}

static void qr_code_generate(qr_code_t *qr_code, const char *data) {
    // TODO: Implement QR code generation algorithm

    qr_code_print(qr_code);
}

int main() {
    qr_code_t qr_code;
    qr_code_init(&qr_code);
    qr_code_generate(&qr_code, "Hello, world!");

    return 0;
}