//MISTRAL-7B DATASET v1.0 Category: Memory management ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    size_t size;
    char *ptr;
} Heart;

void fall_in_love(Heart *he, size_t love_size) {
    if (he->ptr != NULL) {
        free(he->ptr);
        he->ptr = NULL;
    }

    if ((he->ptr = malloc(love_size)) == NULL) {
        fprintf(stderr, "My love, I can't allocate memory for you!\n");
        exit(1);
    }

    memset(he->ptr, '\0', love_size);
    he->size = love_size;

    printf("My love, I have allocated %zu bytes for you.\n", love_size);
}

void express_love(Heart *he) {
    if (he->ptr == NULL) {
        printf("My love, my heart is empty.\n");
        return;
    }

    printf("My love, I have filled my heart with these words: ");
    puts(he->ptr);

    free(he->ptr);
    he->ptr = NULL;
}

int main() {
    Heart my_heart = {0};
    size_t love_size = 50;

    fall_in_love(&my_heart, love_size);

    strncpy(my_heart.ptr, "I love you more than the stars in the night sky.", love_size);

    express_love(&my_heart);

    return 0;
}