//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Cloud types
typedef enum {
    CLEAR,
    CLOUDY,
    OVERCAST,
    RAINING,
    SNOWING
} CloudType;

// Weather conditions
typedef struct {
    CloudType cloud_type;
    double temperature;
    double humidity;
    double wind_speed;
    double wind_direction;
    double precipitation;
} WeatherConditions;

// Generate a random weather condition
WeatherConditions generate_weather_conditions() {
    WeatherConditions conditions;

    // Cloud type
    conditions.cloud_type = rand() % 5;

    // Temperature
    conditions.temperature = (rand() % 20) + 10;

    // Humidity
    conditions.humidity = (rand() % 50) + 50;

    // Wind speed
    conditions.wind_speed = (rand() % 10) + 5;

    // Wind direction
    conditions.wind_direction = rand() % 360;

    // Precipitation
    conditions.precipitation = (rand() % 10) + 5;

    return conditions;
}

// Print the weather conditions
void print_weather_conditions(WeatherConditions conditions) {
    printf("Cloud type: %s\n", conditions.cloud_type == CLEAR ? "Clear" : conditions.cloud_type == CLOUDY ? "Cloudy" : conditions.cloud_type == OVERCAST ? "Overcast" : conditions.cloud_type == RAINING ? "Raining" : "Snowing");
    printf("Temperature: %.1f degrees Celsius\n", conditions.temperature);
    printf("Humidity: %.1f%%\n", conditions.humidity);
    printf("Wind speed: %.1f m/s\n", conditions.wind_speed);
    printf("Wind direction: %.1f degrees\n", conditions.wind_direction);
    printf("Precipitation: %.1f mm\n", conditions.precipitation);
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Generate a random weather condition
    WeatherConditions conditions = generate_weather_conditions();

    // Print the weather conditions
    print_weather_conditions(conditions);

    return 0;
}