//FormAI DATASET v1.0 Category: Socket programming ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 8080

void *connection_handler(void *);

int main(int argc, char const *argv[]) {

    int server_fd, new_socket;
    struct sockaddr_in address;
    int opt = 1;
    int addrlen = sizeof(address);
     
    if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }
     
    if (setsockopt(server_fd, SOL_SOCKET, SO_REUSEADDR | SO_REUSEPORT, &opt, sizeof(opt))) {
        perror("setsockopt");
        exit(EXIT_FAILURE);
    }

    address.sin_family = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY;
    address.sin_port = htons(PORT);
     
    if (bind(server_fd, (struct sockaddr *)&address, sizeof(address))<0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    if (listen(server_fd, 3) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    printf("Server listening on port %d\n", PORT);

    while ((new_socket = accept(server_fd, (struct sockaddr *)&address, (socklen_t*)&addrlen))) {
        printf("New connection accepted.\n");

        pthread_t client_thread;
         
        if (pthread_create(&client_thread, NULL, connection_handler, (void*)&new_socket) < 0) {
            perror("could not create thread");
            exit(EXIT_FAILURE);
        }
    }

    if (new_socket < 0) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    return 0;
}

void *connection_handler(void *socket_desc) {

    int sock = *(int*)socket_desc;
    char buffer[1024] = {0};
    const char* message = "Hello from server!";
     
    send(sock, message, strlen(message), 0);
    
    while (1) {
        memset(buffer, 0, 1024);
        int valread = read(sock, buffer, 1024);
        
        if (valread <= 0) {
            perror("read failed");
            break;
        }
        
        printf("Received message: %s", buffer);

        if (strncmp(buffer, "exit", 4) == 0) {
            printf("Closing connection.\n");
            break;
        }

        send(sock, buffer, strlen(buffer), 0);
    }
     
    close(sock);
    printf("Connection closed.\n");

    pthread_exit(NULL);
}