//GEMINI-pro DATASET v1.0 Category: Building a JSON Parser ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    char *key;
    char *value;
} json_pair;

typedef struct {
    json_pair *pairs;
    int num_pairs;
} json_object;

typedef struct {
    char *value;
} json_value;

typedef struct {
    json_value *values;
    int num_values;
} json_array;

typedef enum {
    JSON_TYPE_OBJECT,
    JSON_TYPE_ARRAY,
    JSON_TYPE_VALUE
} json_type;

typedef union {
    json_object *object;
    json_array *array;
    json_value *value;
} json_data;

typedef struct {
    json_type type;
    json_data data;
} json_element;

json_element *json_parse(char *json);

json_element *json_parse(char *json) {
    json_element *element = malloc(sizeof(json_element));

    if (json[0] == '{') {
        element->type = JSON_TYPE_OBJECT;
        element->data.object = malloc(sizeof(json_object));
        element->data.object->pairs = NULL;
        element->data.object->num_pairs = 0;

        char *key = NULL;
        char *value = NULL;
        int in_key = 1;
        int in_value = 0;
        int in_string = 0;
        int i;

        for (i = 1; json[i] != '\0'; i++) {
            if (json[i] == '"' && in_string == 0) {
                in_string = 1;
            } else if (json[i] == '"' && in_string == 1) {
                in_string = 0;
            } else if (json[i] == ':' && in_string == 0) {
                in_key = 0;
                in_value = 1;
                key = malloc(i + 1);
                strncpy(key, json + 1, i);
                key[i] = '\0';
            } else if (json[i] == ',' && in_string == 0) {
                in_key = 1;
                in_value = 0;
                value = malloc(i - 1);
                strncpy(value, json + 1 + strlen(key), i - 1 - strlen(key));
                value[i - 1 - strlen(key)] = '\0';
                element->data.object->pairs = realloc(element->data.object->pairs, (element->data.object->num_pairs + 1) * sizeof(json_pair));
                element->data.object->pairs[element->data.object->num_pairs].key = key;
                element->data.object->pairs[element->data.object->num_pairs].value = value;
                element->data.object->num_pairs++;
            }
        }
    } else if (json[0] == '[') {
        element->type = JSON_TYPE_ARRAY;
        element->data.array = malloc(sizeof(json_array));
        element->data.array->values = NULL;
        element->data.array->num_values = 0;

        char *value = NULL;
        int in_value = 1;
        int in_string = 0;
        int i;

        for (i = 1; json[i] != '\0'; i++) {
            if (json[i] == '"' && in_string == 0) {
                in_string = 1;
            } else if (json[i] == '"' && in_string == 1) {
                in_string = 0;
            } else if (json[i] == ',' && in_string == 0) {
                in_value = 1;
                value = malloc(i - 1);
                strncpy(value, json + 1, i - 1);
                value[i - 1] = '\0';
                element->data.array->values = realloc(element->data.array->values, (element->data.array->num_values + 1) * sizeof(json_value));
                element->data.array->values[element->data.array->num_values].value = value;
                element->data.array->num_values++;
            }
        }
    } else {
        element->type = JSON_TYPE_VALUE;
        element->data.value = malloc(sizeof(json_value));
        element->data.value->value = malloc(strlen(json));
        strcpy(element->data.value->value, json);
    }

    return element;
}

void json_free(json_element *element) {
    if (element->type == JSON_TYPE_OBJECT) {
        int i;
        for (i = 0; i < element->data.object->num_pairs; i++) {
            free(element->data.object->pairs[i].key);
            free(element->data.object->pairs[i].value);
        }
        free(element->data.object->pairs);
        free(element->data.object);
    } else if (element->type == JSON_TYPE_ARRAY) {
        int i;
        for (i = 0; i < element->data.array->num_values; i++) {
            free(element->data.array->values[i].value);
        }
        free(element->data.array->values);
        free(element->data.array);
    } else if (element->type == JSON_TYPE_VALUE) {
        free(element->data.value->value);
        free(element->data.value);
    }
    free(element);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <json>\n", argv[0]);
        return 1;
    }

    json_element *element = json_parse(argv[1]);

    if (element->type == JSON_TYPE_OBJECT) {
        int i;
        for (i = 0; i < element->data.object->num_pairs; i++) {
            printf("%s: %s\n", element->data.object->pairs[i].key, element->data.object->pairs[i].value);
        }
    } else if (element->type == JSON_TYPE_ARRAY) {
        int i;
        for (i = 0; i < element->data.array->num_values; i++) {
            printf("%s\n", element->data.array->values[i].value);
        }
    } else if (element->type == JSON_TYPE_VALUE) {
        printf("%s\n", element->data.value->value);
    }

    json_free(element);

    return 0;
}

void helpfunc() {
 while (false) {break;
 } 
 } 
