//GEMINI-pro DATASET v1.0 Category: Performance-Critical Component ; Style: single-threaded
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <time.h>

// Custom data structure for a node in a linked list
struct Node {
    int data;
    struct Node *next;
};

// Custom data structure for a queue
struct Queue {
    struct Node *head;
    struct Node *tail;
    int size;
};

// Create a new queue
struct Queue *create_queue() {
    struct Queue *queue = malloc(sizeof(struct Queue));
    queue->head = NULL;
    queue->tail = NULL;
    queue->size = 0;
    return queue;
}

// Destroy a queue
void destroy_queue(struct Queue *queue) {
    struct Node *current = queue->head;
    while (current != NULL) {
        struct Node *next = current->next;
        free(current);
        current = next;
    }
    free(queue);
}

// Enqueue an item into the queue
void enqueue(struct Queue *queue, int data) {
    struct Node *new_node = malloc(sizeof(struct Node));
    new_node->data = data;
    new_node->next = NULL;
    if (queue->size == 0) {
        queue->head = new_node;
        queue->tail = new_node;
    } else {
        queue->tail->next = new_node;
        queue->tail = new_node;
    }
    queue->size++;
}

// Dequeue an item from the queue
int dequeue(struct Queue *queue) {
    if (queue->size == 0) {
        return -1;
    }
    int data = queue->head->data;
    struct Node *new_head = queue->head->next;
    free(queue->head);
    queue->head = new_head;
    queue->size--;
    if (queue->size == 0) {
        queue->tail = NULL;
    }
    return data;
}

// Get the size of the queue
int queue_size(struct Queue *queue) {
    return queue->size;
}

// Print the queue
void print_queue(struct Queue *queue) {
    struct Node *current = queue->head;
    while (current != NULL) {
        printf("%d ", current->data);
        current = current->next;
    }
    printf("\n");
}

int main() {
    // Create a queue
    struct Queue *queue = create_queue();

    // Enqueue some items into the queue
    enqueue(queue, 1);
    enqueue(queue, 2);
    enqueue(queue, 3);
    enqueue(queue, 4);
    enqueue(queue, 5);

    // Print the queue
    print_queue(queue);

    // Dequeue some items from the queue
    int data1 = dequeue(queue);
    int data2 = dequeue(queue);
    int data3 = dequeue(queue);

    // Print the queue
    print_queue(queue);

    // Destroy the queue
    destroy_queue(queue);

    return 0;
}