
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
    char* name;
    int points;
} Player;

typedef struct {
    Player* players;
    int num_players;
} Game;

void initialize_game(Game* game) {
    game->players = malloc(sizeof(Player) * game->num_players);
    for (int i = 0; i < game->num_players; i++) {
        game->players[i].points = 0;
        game->players[i].name = malloc(sizeof(char) * 20);
    }
}

void add_player(Game* game, char* name) {
    int num_players = game->num_players;
    game->players = realloc(game->players, sizeof(Player) * (num_players + 1));
    game->players[num_players].name = malloc(sizeof(char) * 20);
    strcpy(game->players[num_players].name, name);
    game->num_players++;
}

void print_game(Game game) {
    for (int i = 0; i < game.num_players; i++) {
        printf("Player %d: %s, %d points\n", i+1, game.players[i].name, game.players[i].points);
    }
}

void update_points(Game game, char* winner) {
    int num_players = game.num_players;
    for (int i = 0; i < num_players; i++) {
        if (strcmp(game.players[i].name, winner) == 0) {
            game.players[i].points++;
            break;
        }
    }
}

void play_round(Game game) {
    for (int i = 0; i < game.num_players; i++) {
        printf("Player %d: %s, %d points\n", i+1, game.players[i].name, game.players[i].points);
    }
    printf("Round 1:\n");
    for (int i = 0; i < game.num_players; i++) {
        printf("Player %d: %s\n", i+1, game.players[i].name);
    }
    int num_players = game.num_players;
    char* winner;
    for (int i = 0; i < num_players; i++) {
        srand(time(NULL));
        int j = rand() % num_players;
        if (i == j) {
            continue;
        }
        if (strcmp(game.players[i].name, game.players[j].name) > 0) {
            winner = game.players[i].name;
            break;
        }
    }
    update_points(game, winner);
}

void play_game(Game game) {
    int num_players = game.num_players;
    char* winner;
    for (int i = 0; i < num_players; i++) {
        play_round(game);
        if (game.players[i].points >= 5) {
            winner = game.players[i].name;
            break;
        }
    }
    print_game(game);
    printf("Winner: %s\n", winner);
}

int main() {
    Game game;
    initialize_game(&game);
    add_player(&game, "Alice");
    add_player(&game, "Bob");
    add_player(&game, "Charlie");
    play_game(game);
    free(game.players);
    return 0;
}