//GEMINI-pro DATASET v1.0 Category: Data structures visualization ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the node structure
struct node {
    int data;
    struct node *next;
};

// Define the linked list structure
struct linked_list {
    struct node *head;
    struct node *tail;
    int size;
};

// Create a new linked list
struct linked_list *create_list() {
    struct linked_list *list = (struct linked_list *)malloc(sizeof(struct linked_list));
    list->head = NULL;
    list->tail = NULL;
    list->size = 0;
    return list;
}

// Insert a new node at the beginning of the linked list
void insert_at_beginning(struct linked_list *list, int data) {
    struct node *new_node = (struct node *)malloc(sizeof(struct node));
    new_node->data = data;
    new_node->next = list->head;
    list->head = new_node;
    if (list->tail == NULL) {
        list->tail = new_node;
    }
    list->size++;
}

// Insert a new node at the end of the linked list
void insert_at_end(struct linked_list *list, int data) {
    struct node *new_node = (struct node *)malloc(sizeof(struct node));
    new_node->data = data;
    new_node->next = NULL;
    if (list->tail == NULL) {
        list->head = new_node;
        list->tail = new_node;
    } else {
        list->tail->next = new_node;
        list->tail = new_node;
    }
    list->size++;
}

// Insert a new node at a specified position in the linked list
void insert_at_position(struct linked_list *list, int data, int position) {
    if (position == 0) {
        insert_at_beginning(list, data);
    } else if (position == list->size) {
        insert_at_end(list, data);
    } else {
        struct node *new_node = (struct node *)malloc(sizeof(struct node));
        new_node->data = data;
        struct node *current_node = list->head;
        for (int i = 0; i < position - 1; i++) {
            current_node = current_node->next;
        }
        new_node->next = current_node->next;
        current_node->next = new_node;
        list->size++;
    }
}

// Delete a node from the beginning of the linked list
void delete_at_beginning(struct linked_list *list) {
    if (list->head == NULL) {
        return;
    }
    struct node *current_node = list->head;
    list->head = current_node->next;
    if (list->head == NULL) {
        list->tail = NULL;
    }
    free(current_node);
    list->size--;
}

// Delete a node from the end of the linked list
void delete_at_end(struct linked_list *list) {
    if (list->tail == NULL) {
        return;
    }
    struct node *current_node = list->head;
    while (current_node->next != list->tail) {
        current_node = current_node->next;
    }
    struct node *temp = list->tail;
    current_node->next = NULL;
    list->tail = current_node;
    if (list->head == NULL) {
        list->tail = NULL;
    }
    free(temp);
    list->size--;
}

// Delete a node from a specified position in the linked list
void delete_at_position(struct linked_list *list, int position) {
    if (position == 0) {
        delete_at_beginning(list);
    } else if (position == list->size - 1) {
        delete_at_end(list);
    } else {
        struct node *current_node = list->head;
        for (int i = 0; i < position - 1; i++) {
            current_node = current_node->next;
        }
        struct node *temp = current_node->next;
        current_node->next = current_node->next->next;
        free(temp);
        list->size--;
    }
}

// Print the linked list
void print_list(struct linked_list *list) {
    if (list->head == NULL) {
        printf("Empty list\n");
        return;
    }
    struct node *current_node = list->head;
    while (current_node != NULL) {
        printf("%d ", current_node->data);
        current_node = current_node->next;
    }
    printf("\n");
}

int main() {
    // Create a new linked list
    struct linked_list *list = create_list();

    // Insert some data into the linked list
    insert_at_beginning(list, 10);
    insert_at_end(list, 20);
    insert_at_position(list, 30, 1);

    // Print the linked list
    printf("Linked list: ");
    print_list(list);

    // Delete a node from the beginning of the linked list
    delete_at_beginning(list);

    // Print the linked list
    printf("Linked list after deleting a node from the beginning: ");
    print_list(list);

    // Delete a node from the end of the linked list
    delete_at_end(list);

    // Print the linked list
    printf("Linked list after deleting a node from the end: ");
    print_list(list);

    // Delete a node from a specified position in the linked list
    delete_at_position(list, 1);

    // Print the linked list
    printf("Linked list after deleting a node from a specified position: ");
    print_list(list);

    // Free the linked list
    free(list);

    return 0;
}