//GEMINI-pro DATASET v1.0 Category: File handling ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// **Unique** File Type Definitions

typedef struct Node {
    char data;
    struct Node *next;
} Node_t;

typedef struct LinkedList {
    Node_t *head;
    Node_t *tail;
} LinkedList_t;

typedef struct File {
    char *name;
    LinkedList_t *lines;
} File_t;

// **Unique** File Handling Functions

File_t *create_file(char *name) {
    File_t *file = (File_t *)malloc(sizeof(File_t));
    file->name = (char *)malloc(strlen(name) + 1);
    strcpy(file->name, name);
    file->lines = (LinkedList_t *)malloc(sizeof(LinkedList_t));
    file->lines->head = NULL;
    file->lines->tail = NULL;
    return file;
}

void write_line_to_file(File_t *file, char *line) {
    Node_t *node = (Node_t *)malloc(sizeof(Node_t));
    node->data = (char *)malloc(strlen(line) + 1);
    strcpy(node->data, line);
    node->next = NULL;
    if (file->lines->head == NULL) {
        file->lines->head = node;
        file->lines->tail = node;
    } else {
        file->lines->tail->next = node;
        file->lines->tail = node;
    }
}

char *read_line_from_file(File_t *file, int line_number) {
    Node_t *node = file->lines->head;
    for (int i = 0; i < line_number; i++) {
        if (node == NULL) {
            return NULL;
        } else {
            node = node->next;
        }
    }
    if (node == NULL) {
        return NULL;
    } else {
        return node->data;
    }
}

void delete_file(File_t *file) {
    // Free the linked list nodes
    Node_t *node = file->lines->head;
    while (node != NULL) {
        Node_t *next = node->next;
        free(node);
        node = next;
    }
    // Free the linked list
    free(file->lines);
    // Free the file name
    free(file->name);
    // Free the file
    free(file);
}

// **Usage Example**

int main() {
    // Create a new file
    File_t *file = create_file("test.txt");

    // Write some lines to the file
    write_line_to_file(file, "Line 1");
    write_line_to_file(file, "Line 2");
    write_line_to_file(file, "Line 3");

    // Read a specific line from the file
    char *line = read_line_from_file(file, 2);
    printf("Line 2: %s\n", line);

    // Delete the file
    delete_file(file);

    return 0;
}