//MISTRAL-7B DATASET v1.0 Category: Typing Speed Test ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define WORD_COUNT 20
#define MAX_INPUT_LENGTH 100

typedef struct Node {
    char input[MAX_INPUT_LENGTH];
    struct Node* next;
} Node;

void generate_words(char words[][MAX_INPUT_LENGTH], int size);
void print_words(char words[][MAX_INPUT_LENGTH], int size);
void add_to_list(Node** head, char input[]);
void free_list(Node** head);
int main() {
    clock_t start, end;
    double time_spent;
    int i, accuracy;
    char words[WORD_COUNT][MAX_INPUT_LENGTH];
    generate_words(words, WORD_COUNT);
    Node* head = NULL;
    int correct_count = 0;

    printf("\nTyphoon Typing Speed Test\n");
    printf("---------------------------\n");
    printf("Type the given words as fast as you can:\n");

    for (i = 0; i < WORD_COUNT; i++) {
        start = clock();
        printf("\nWord %d: %s", i + 1, words[i]);
        fgets(words[i], MAX_INPUT_LENGTH, stdin);
        words[i][strcspn(words[i], "\n")] = '\0';
        add_to_list(&head, words[i]);
        end = clock();
        time_spent = (double)(end - start) / CLOCKS_PER_SEC;
        if (strcmp(words[i], words[i]) == 0) {
            correct_count++;
        }
        printf("Time taken: %.10fs\n", time_spent);
    }

    accuracy = (int)(((double)correct_count / WORD_COUNT) * 100);
    printf("\nTotal correct words: %d\n", correct_count);
    printf("Accuracy: %d%%\n", accuracy);
    free_list(&head);

    return 0;
}

void generate_words(char words[][MAX_INPUT_LENGTH], int size) {
    int i;
    for (i = 0; i < size; i++) {
        sprintf(words[i], "Elephant%d", i + 1);
    }
}

void print_words(char words[][MAX_INPUT_LENGTH], int size) {
    int i;
    for (i = 0; i < size; i++) {
        printf("%s ", words[i]);
    }
    printf("\n");
}

void add_to_list(Node** head, char input[]) {
    Node* new_node = (Node*)malloc(sizeof(Node));
    strcpy(new_node->input, input);
    new_node->next = *head;
    *head = new_node;
}

void free_list(Node** head) {
    Node* current, * next;
    current = *head;
    while (current != NULL) {
        next = current->next;
        free(current);
        current = next;
    }
    *head = NULL;
}