//Code Llama-13B DATASET v1.0 Category: Data structures visualization ; Style: configurable
// Data structures visualization program
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structures to store data
struct node {
  int value;
  struct node* next;
};

struct list {
  struct node* head;
  struct node* tail;
};

struct tree {
  struct tree* left;
  struct tree* right;
  int value;
};

// Function to create a new node
struct node* newNode(int value) {
  struct node* node = (struct node*) malloc(sizeof(struct node));
  node->value = value;
  node->next = NULL;
  return node;
}

// Function to create a new list
struct list* newList() {
  struct list* list = (struct list*) malloc(sizeof(struct list));
  list->head = NULL;
  list->tail = NULL;
  return list;
}

// Function to create a new tree
struct tree* newTree(int value) {
  struct tree* tree = (struct tree*) malloc(sizeof(struct tree));
  tree->left = NULL;
  tree->right = NULL;
  tree->value = value;
  return tree;
}

// Function to add a node to a list
void addNodeToList(struct list* list, int value) {
  struct node* node = newNode(value);
  if (list->head == NULL) {
    list->head = node;
    list->tail = node;
  } else {
    list->tail->next = node;
    list->tail = node;
  }
}

// Function to add a node to a tree
void addNodeToTree(struct tree* tree, int value) {
  if (tree->value < value) {
    if (tree->right == NULL) {
      tree->right = newTree(value);
    } else {
      addNodeToTree(tree->right, value);
    }
  } else {
    if (tree->left == NULL) {
      tree->left = newTree(value);
    } else {
      addNodeToTree(tree->left, value);
    }
  }
}

// Function to print a list
void printList(struct list* list) {
  struct node* node = list->head;
  while (node != NULL) {
    printf("%d ", node->value);
    node = node->next;
  }
  printf("\n");
}

// Function to print a tree
void printTree(struct tree* tree) {
  if (tree->left != NULL) {
    printTree(tree->left);
  }
  printf("%d ", tree->value);
  if (tree->right != NULL) {
    printTree(tree->right);
  }
}

// Driver code
int main() {
  // Create a list
  struct list* list = newList();
  addNodeToList(list, 1);
  addNodeToList(list, 2);
  addNodeToList(list, 3);
  addNodeToList(list, 4);
  addNodeToList(list, 5);
  printList(list);

  // Create a tree
  struct tree* tree = newTree(5);
  addNodeToTree(tree, 3);
  addNodeToTree(tree, 2);
  addNodeToTree(tree, 1);
  addNodeToTree(tree, 4);
  printTree(tree);

  return 0;
}