
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#define SAMPLES 1024
#define BITS_PER_SAMPLE 16
#define SAMPLE_RATE 44100

float *audio_buffer;
float *filtered_audio_buffer;

void sigint_handler(int sig) {
    printf("Caught signal %d, exiting...\n", sig);
    exit(0);
}

int main(int argc, char *argv[]) {
    
    audio_buffer = (float *)malloc(SAMPLES * sizeof(float));
    if (!audio_buffer) {
        perror("Failed to allocate audio buffer");
        exit(1);
    }

    
    filtered_audio_buffer = (float *)malloc(SAMPLES * sizeof(float));
    if (!filtered_audio_buffer) {
        perror("Failed to allocate filtered audio buffer");
        exit(1);
    }

    
    signal(SIGINT, sigint_handler);

    
    FILE *audio_file = fopen("audio_file.wav", "rb");
    if (!audio_file) {
        perror("Failed to open audio file");
        exit(1);
    }

    
    fread(audio_buffer, sizeof(float), SAMPLES, audio_file);
    fclose(audio_file);

    
    for (int i = 0; i < SAMPLES; i++) {
        filtered_audio_buffer[i] = audio_buffer[i] * 0.5;
    }

    
    for (int i = 0; i < SAMPLES; i++) {
        printf("%.4f ", filtered_audio_buffer[i]);
    }

    
    free(audio_buffer);
    free(filtered_audio_buffer);

    return 0;
}