//GEMINI-pro DATASET v1.0 Category: Digital Watermarking ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Function to embed the watermark into the image
void embedWatermark(unsigned char *image, int width, int height, unsigned char *watermark, int watermarkWidth, int watermarkHeight) {
  // Loop through each pixel in the image
  for (int i = 0; i < width * height; i++) {
    // Get the red, green, and blue values of the pixel
    unsigned char red = image[i * 3];
    unsigned char green = image[i * 3 + 1];
    unsigned char blue = image[i * 3 + 2];

    // Get the corresponding pixel in the watermark
    int watermarkX = i % width;
    int watermarkY = i / width;
    unsigned char watermarkPixel = watermark[watermarkX * watermarkHeight + watermarkY];

    // Embed the watermark into the pixel
    red = red & 0b11111000;
    red |= watermarkPixel >> 5;
    green = green & 0b11111100;
    green |= (watermarkPixel >> 2) & 0b00000011;
    blue = blue & 0b11111110;
    blue |= watermarkPixel & 0b00000001;

    // Set the new pixel values
    image[i * 3] = red;
    image[i * 3 + 1] = green;
    image[i * 3 + 2] = blue;
  }
}

// Function to extract the watermark from the image
unsigned char *extractWatermark(unsigned char *image, int width, int height, int watermarkWidth, int watermarkHeight) {
  // Allocate memory for the watermark
  unsigned char *watermark = malloc(watermarkWidth * watermarkHeight);

  // Loop through each pixel in the watermark
  for (int i = 0; i < watermarkWidth * watermarkHeight; i++) {
    // Get the corresponding pixel in the image
    int imageX = i % watermarkWidth;
    int imageY = i / watermarkWidth;
    int imagePixelIndex = imageX + imageY * width;

    // Get the red, green, and blue values of the pixel
    unsigned char red = image[imagePixelIndex * 3];
    unsigned char green = image[imagePixelIndex * 3 + 1];
    unsigned char blue = image[imagePixelIndex * 3 + 2];

    // Extract the watermark pixel
    unsigned char watermarkPixel = (red & 0b00000111) << 5;
    watermarkPixel |= (green & 0b00000011) << 2;
    watermarkPixel |= blue & 0b00000001;

    // Set the watermark pixel
    watermark[i] = watermarkPixel;
  }

  // Return the watermark
  return watermark;
}

// Main function
int main() {
  // Load the image
  FILE *imageFile = fopen("image.bmp", "rb");
  if (imageFile == NULL) {
    printf("Error opening image file.\n");
    return 1;
  }

  // Get the image dimensions
  int width, height;
  fread(&width, sizeof(int), 1, imageFile);
  fread(&height, sizeof(int), 1, imageFile);

  // Load the image data
  unsigned char *image = malloc(width * height * 3);
  fread(image, 1, width * height * 3, imageFile);
  fclose(imageFile);

  // Load the watermark
  FILE *watermarkFile = fopen("watermark.bmp", "rb");
  if (watermarkFile == NULL) {
    printf("Error opening watermark file.\n");
    return 1;
  }

  // Get the watermark dimensions
  int watermarkWidth, watermarkHeight;
  fread(&watermarkWidth, sizeof(int), 1, watermarkFile);
  fread(&watermarkHeight, sizeof(int), 1, watermarkFile);

  // Load the watermark data
  unsigned char *watermark = malloc(watermarkWidth * watermarkHeight);
  fread(watermark, 1, watermarkWidth * watermarkHeight, watermarkFile);
  fclose(watermarkFile);

  // Embed the watermark into the image
  embedWatermark(image, width, height, watermark, watermarkWidth, watermarkHeight);

  // Save the watermarked image
  FILE *watermarkedImageFile = fopen("watermarked_image.bmp", "wb");
  if (watermarkedImageFile == NULL) {
    printf("Error opening watermarked image file.\n");
    return 1;
  }

  // Write the image dimensions
  fwrite(&width, sizeof(int), 1, watermarkedImageFile);
  fwrite(&height, sizeof(int), 1, watermarkedImageFile);

  // Write the image data
  fwrite(image, 1, width * height * 3, watermarkedImageFile);
  fclose(watermarkedImageFile);

  // Extract the watermark from the image
  unsigned char *extractedWatermark = extractWatermark(image, width, height, watermarkWidth, watermarkHeight);

  // Save the extracted watermark
  FILE *extractedWatermarkFile = fopen("extracted_watermark.bmp", "wb");
  if (extractedWatermarkFile == NULL) {
    printf("Error opening extracted watermark file.\n");
    return 1;
  }

  // Write the watermark dimensions
  fwrite(&watermarkWidth, sizeof(int), 1, extractedWatermarkFile);
  fwrite(&watermarkHeight, sizeof(int), 1, extractedWatermarkFile);

  // Write the watermark data
  fwrite(extractedWatermark, 1, watermarkWidth * watermarkHeight, extractedWatermarkFile);
  fclose(extractedWatermarkFile);

  // Free the allocated memory
  free(image);
  free(watermark);
  free(extractedWatermark);

  return 0;
}