//GEMINI-pro DATASET v1.0 Category: Classical Circuit Simulator ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_COMPONENTS 100
#define MAX_NETS 100
#define MAX_INPUTS 100
#define MAX_OUTPUTS 100

typedef enum {
  COMPONENT_TYPE_RESISTOR,
  COMPONENT_TYPE_CAPACITOR,
  COMPONENT_TYPE_INDUCTOR,
  COMPONENT_TYPE_DIODE,
  COMPONENT_TYPE_TRANSISTOR
} component_type;

typedef struct {
  component_type type;
  char *name;
  double value;
  int num_terminals;
  int terminals[2];
} component;

typedef struct {
  char *name;
  int num_nodes;
  int nodes[2];
} net;

typedef struct {
  char *name;
  int value;
} input;

typedef struct {
  char *name;
  int value;
} output;

component components[MAX_COMPONENTS];
net nets[MAX_NETS];
input inputs[MAX_INPUTS];
output outputs[MAX_OUTPUTS];

int num_components = 0;
int num_nets = 0;
int num_inputs = 0;
int num_outputs = 0;

void add_component(component_type type, char *name, double value, int num_terminals, int terminals[2]) {
  components[num_components].type = type;
  components[num_components].name = strdup(name);
  components[num_components].value = value;
  components[num_components].num_terminals = num_terminals;
  memcpy(components[num_components].terminals, terminals, sizeof(int) * num_terminals);
  num_components++;
}

void add_net(char *name, int num_nodes, int nodes[2]) {
  nets[num_nets].name = strdup(name);
  nets[num_nets].num_nodes = num_nodes;
  memcpy(nets[num_nets].nodes, nodes, sizeof(int) * num_nodes);
  num_nets++;
}

void add_input(char *name, int value) {
  inputs[num_inputs].name = strdup(name);
  inputs[num_inputs].value = value;
  num_inputs++;
}

void add_output(char *name, int value) {
  outputs[num_outputs].name = strdup(name);
  outputs[num_outputs].value = value;
  num_outputs++;
}

void print_components() {
  for (int i = 0; i < num_components; i++) {
    printf("Component %d:\n", i);
    printf("  Type: %d\n", components[i].type);
    printf("  Name: %s\n", components[i].name);
    printf("  Value: %f\n", components[i].value);
    printf("  Num Terminals: %d\n", components[i].num_terminals);
    printf("  Terminals: ");
    for (int j = 0; j < components[i].num_terminals; j++) {
      printf("%d ", components[i].terminals[j]);
    }
    printf("\n");
  }
}

void print_nets() {
  for (int i = 0; i < num_nets; i++) {
    printf("Net %d:\n", i);
    printf("  Name: %s\n", nets[i].name);
    printf("  Num Nodes: %d\n", nets[i].num_nodes);
    printf("  Nodes: ");
    for (int j = 0; j < nets[i].num_nodes; j++) {
      printf("%d ", nets[i].nodes[j]);
    }
    printf("\n");
  }
}

void print_inputs() {
  for (int i = 0; i < num_inputs; i++) {
    printf("Input %d:\n", i);
    printf("  Name: %s\n", inputs[i].name);
    printf("  Value: %d\n", inputs[i].value);
  }
}

void print_outputs() {
  for (int i = 0; i < num_outputs; i++) {
    printf("Output %d:\n", i);
    printf("  Name: %s\n", outputs[i].name);
    printf("  Value: %d\n", outputs[i].value);
  }
}

int main() {
  // Add components
  add_component(COMPONENT_TYPE_RESISTOR, "R1", 100, 2, (int[]){0, 1});
  add_component(COMPONENT_TYPE_CAPACITOR, "C1", 10e-6, 2, (int[]){1, 2});
  add_component(COMPONENT_TYPE_INDUCTOR, "L1", 1e-3, 2, (int[]){2, 3});
  add_component(COMPONENT_TYPE_DIODE, "D1", 0.7, 2, (int[]){3, 4});
  add_component(COMPONENT_TYPE_TRANSISTOR, "Q1", 100, 3, (int[]){4, 5, 6});

  // Add nets
  add_net("N1", 2, (int[]){0, 1});
  add_net("N2", 3, (int[]){1, 2, 3});
  add_net("N3", 2, (int[]){3, 4});
  add_net("N4", 2, (int[]){4, 5});
  add_net("N5", 2, (int[]){5, 6});

  // Add inputs
  add_input("IN1", 1);
  add_input("IN2", 0);

  // Add outputs
  add_output("OUT1", 1);
  add_output("OUT2", 0);

  // Print components
  printf("Components:\n");
  print_components();

  // Print nets
  printf("\nNets:\n");
  print_nets();

  // Print inputs
  printf("\nInputs:\n");
  print_inputs();

  // Print outputs
  printf("\nOutputs:\n");
  print_outputs();

  return 0;
}