//GEMINI-pro DATASET v1.0 Category: Data structures visualization ; Style: modular
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <ctype.h>
#include <string.h>

// Defines the maximum number of elements in the array
#define MAX_SIZE 100

// Define the node structure
typedef struct node {
  int data;
  struct node *next;
} node_t;

// Define the linked list structure
typedef struct linked_list {
  node_t *head;
  node_t *tail;
  int size;
} linked_list_t;

// Create a new node
node_t *create_node(int data) {
  node_t *new_node = (node_t *)malloc(sizeof(node_t));
  new_node->data = data;
  new_node->next = NULL;
  return new_node;
}

// Create a new linked list
linked_list_t *create_linked_list() {
  linked_list_t *new_list = (linked_list_t *)malloc(sizeof(linked_list_t));
  new_list->head = NULL;
  new_list->tail = NULL;
  new_list->size = 0;
  return new_list;
}

// Insert a new node at the beginning of the linked list
void insert_at_beginning(linked_list_t *list, int data) {
  node_t *new_node = create_node(data);
  if (list->head == NULL) {
    list->head = new_node;
    list->tail = new_node;
  } else {
    new_node->next = list->head;
    list->head = new_node;
  }
  list->size++;
}

// Insert a new node at the end of the linked list
void insert_at_end(linked_list_t *list, int data) {
  node_t *new_node = create_node(data);
  if (list->head == NULL) {
    list->head = new_node;
    list->tail = new_node;
  } else {
    list->tail->next = new_node;
    list->tail = new_node;
  }
  list->size++;
}

// Insert a new node at a specific position in the linked list
void insert_at_position(linked_list_t *list, int data, int position) {
  if (position < 0 || position > list->size) {
    printf("Invalid position.\n");
    return;
  }

  node_t *new_node = create_node(data);

  if (position == 0) {
    insert_at_beginning(list, data);
  } else if (position == list->size) {
    insert_at_end(list, data);
  } else {
    node_t *current_node = list->head;
    for (int i = 0; i < position - 1; i++) {
      current_node = current_node->next;
    }
    new_node->next = current_node->next;
    current_node->next = new_node;
    list->size++;
  }
}

// Delete the node at the beginning of the linked list
void delete_at_beginning(linked_list_t *list) {
  if (list->head == NULL) {
    printf("List is empty.\n");
    return;
  }

  node_t *temp = list->head;
  list->head = list->head->next;
  if (list->head == NULL) {
    list->tail = NULL;
  }
  free(temp);
  list->size--;
}

// Delete the node at the end of the linked list
void delete_at_end(linked_list_t *list) {
  if (list->head == NULL) {
    printf("List is empty.\n");
    return;
  }

  node_t *current_node = list->head;
  while (current_node->next != list->tail) {
    current_node = current_node->next;
  }

  node_t *temp = list->tail;
  list->tail = current_node;
  list->tail->next = NULL;
  free(temp);
  list->size--;
}

// Delete the node at a specific position in the linked list
void delete_at_position(linked_list_t *list, int position) {
  if (position < 0 || position >= list->size) {
    printf("Invalid position.\n");
    return;
  }

  if (position == 0) {
    delete_at_beginning(list);
  } else if (position == list->size - 1) {
    delete_at_end(list);
  } else {
    node_t *current_node = list->head;
    for (int i = 0; i < position - 1; i++) {
      current_node = current_node->next;
    }

    node_t *temp = current_node->next;
    current_node->next = temp->next;
    free(temp);
    list->size--;
  }
}

// Print the linked list
void print_linked_list(linked_list_t *list) {
  if (list->head == NULL) {
    printf("List is empty.\n");
    return;
  }

  node_t *current_node = list->head;
  while (current_node != NULL) {
    printf("%d ", current_node->data);
    current_node = current_node->next;
  }
  printf("\n");
}

// Free the linked list
void free_linked_list(linked_list_t *list) {
  if (list->head == NULL) {
    return;
  }

  node_t *current_node = list->head;
  node_t *next_node;
  while (current_node != NULL) {
    next_node = current_node->next;
    free(current_node);
    current_node = next_node;
  }

  free(list);
}

// Main function
int main() {
  linked_list_t *list = create_linked_list();

  // Insert some data into the linked list
  insert_at_beginning(list, 1);
  insert_at_end(list, 3);
  insert_at_position(list, 2, 1);

  // Print the linked list
  printf("Linked list: ");
  print_linked_list(list);

  // Delete the first node
  delete_at_beginning(list);

  // Print the linked list
  printf("Linked list after deleting the first node: ");
  print_linked_list(list);

  // Delete the last node
  delete_at_end(list);

  // Print the linked list
  printf("Linked list after deleting the last node: ");
  print_linked_list(list);

  // Delete the node at position 0
  delete_at_position(list, 0);

  // Print the linked list
  printf("Linked list after deleting the node at position 0: ");
  print_linked_list(list);

  // Free the linked list
  free_linked_list(list);

  return 0;
}