//GEMINI-pro DATASET v1.0 Category: Modern Encryption ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Swap two characters
void swap(char *a, char *b) {
  char temp = *a;
  *a = *b;
  *b = temp;
}

// Perform a round of encryption
void encrypt_round(char *key, char *input) {
  for (int i = 0; i < strlen(input); i++) {
    input[i] ^= key[i % strlen(key)];
  }
}

// Perform a round of decryption
void decrypt_round(char *key, char *input) {
  for (int i = 0; i < strlen(input); i++) {
    input[i] ^= key[i % strlen(key)];
  }
}

// Apply a substitution cipher
void substitute(char *input) {
  for (int i = 0; i < strlen(input); i++) {
    input[i] = (input[i] - 'a' + 1) % 26 + 'a';
  }
}

// Apply a transposition cipher
void transpose(char *input) {
  int n = strlen(input);
  int m = (n + 2) / 3;
  char grid[m][n];
  int k = 0;
  for (int i = 0; i < m; i++) {
    for (int j = 0; j < n; j++) {
      grid[i][j] = input[k++];
    }
  }
  k = 0;
  for (int j = 0; j < n; j++) {
    for (int i = 0; i < m; i++) {
      input[k++] = grid[i][j];
    }
  }
}

// Generate a random key
void generate_key(char *key, int len) {
  for (int i = 0; i < len; i++) {
    key[i] = (rand() % 26) + 'a';
  }
}

// Encrypt a message
char *encrypt(char *key, char *input) {
  int len = strlen(input);
  char *output = malloc(len + 1);
  strcpy(output, input);
  encrypt_round(key, output);
  substitute(output);
  transpose(output);
  return output;
}

// Decrypt a message
char *decrypt(char *key, char *input) {
  int len = strlen(input);
  char *output = malloc(len + 1);
  strcpy(output, input);
  transpose(output);
  substitute(output);
  encrypt_round(key, output);
  return output;
}

int main() {
  char key[10];
  generate_key(key, 10);
  printf("Key: %s\n", key);

  char input[] = "Hello, world!";
  char *encrypted = encrypt(key, input);
  printf("Encrypted: %s\n", encrypted);

  char *decrypted = decrypt(key, encrypted);
  printf("Decrypted: %s\n", decrypted);

  return 0;
}