//Gemma-7B DATASET v1.0 Category: Password management ; Style: peaceful
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#define MAX_PASSWORDS 10
#define PASSWORD_LENGTH 20

typedef struct Password {
  char *name;
  char *password;
  int used;
} Password;

void create_password(Password *passwords) {
  passwords->name = malloc(PASSWORD_LENGTH);
  passwords->password = malloc(PASSWORD_LENGTH);
  passwords->used = 0;
}

void store_password(Password *passwords, char *name, char *password) {
  strcpy(passwords->name, name);
  strcpy(passwords->password, password);
  passwords->used = 1;
}

char *retrieve_password(Password *passwords, char *name) {
  for (int i = 0; i < MAX_PASSWORDS; i++) {
    if (passwords[i].used && strcmp(passwords[i].name, name) == 0) {
      return passwords[i].password;
    }
  }
  return NULL;
}

int main() {
  Password passwords[MAX_PASSWORDS];
  for (int i = 0; i < MAX_PASSWORDS; i++) {
    create_password(&passwords[i]);
  }

  store_password(passwords, "Alice", "Secret1");
  store_password(passwords, "Bob", "Secret2");
  store_password(passwords, "Charlie", "Secret3");

  char *password = retrieve_password(passwords, "Alice");
  if (password) {
    printf("Alice's password is: %s\n", password);
  } else {
    printf("Error retrieving password.\n");
  }

  return 0;
}