//GEMINI-pro DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define NUM_CHECKIN_COUNTERS 3
#define NUM_BAGGAGE_CLAIM_BELTS 4
#define MAX_BAGGAGE_ITEMS 100

typedef struct baggage_item {
    int id;
    char *destination;
    bool checked_in;
    bool claimed;
} baggage_item;

typedef struct checkin_counter {
    int id;
    int num_bags_checked_in;
    baggage_item *bags_checked_in[MAX_BAGGAGE_ITEMS];
} checkin_counter;

typedef struct baggage_claim_belt {
    int id;
    int num_bags_claimed;
    baggage_item *bags_claimed[MAX_BAGGAGE_ITEMS];
} baggage_claim_belt;

checkin_counter checkin_counters[NUM_CHECKIN_COUNTERS];
baggage_claim_belt baggage_claim_belts[NUM_BAGGAGE_CLAIM_BELTS];
baggage_item baggage_items[MAX_BAGGAGE_ITEMS];

void create_baggage_items() {
    for (int i = 0; i < MAX_BAGGAGE_ITEMS; i++) {
        baggage_items[i].id = i;
        baggage_items[i].destination = malloc(100);
        sprintf(baggage_items[i].destination, "Destination %d", i);
        baggage_items[i].checked_in = false;
        baggage_items[i].claimed = false;
    }
}

void create_checkin_counters() {
    for (int i = 0; i < NUM_CHECKIN_COUNTERS; i++) {
        checkin_counters[i].id = i;
        checkin_counters[i].num_bags_checked_in = 0;
        for (int j = 0; j < MAX_BAGGAGE_ITEMS; j++) {
            checkin_counters[i].bags_checked_in[j] = NULL;
        }
    }
}

void create_baggage_claim_belts() {
    for (int i = 0; i < NUM_BAGGAGE_CLAIM_BELTS; i++) {
        baggage_claim_belts[i].id = i;
        baggage_claim_belts[i].num_bags_claimed = 0;
        for (int j = 0; j < MAX_BAGGAGE_ITEMS; j++) {
            baggage_claim_belts[i].bags_claimed[j] = NULL;
        }
    }
}

void check_in_baggage(int checkin_counter_id, int baggage_item_id) {
    checkin_counter *checkin_counter = &checkin_counters[checkin_counter_id];
    baggage_item *baggage_item = &baggage_items[baggage_item_id];

    if (checkin_counter->num_bags_checked_in >= MAX_BAGGAGE_ITEMS) {
        printf("Error: Check-in counter %d is full.\n", checkin_counter->id);
        return;
    }

    baggage_item->checked_in = true;
    checkin_counter->bags_checked_in[checkin_counter->num_bags_checked_in++] = baggage_item;
}

void claim_baggage(int baggage_claim_belt_id, int baggage_item_id) {
    baggage_claim_belt *baggage_claim_belt = &baggage_claim_belts[baggage_claim_belt_id];
    baggage_item *baggage_item = &baggage_items[baggage_item_id];

    if (baggage_claim_belt->num_bags_claimed >= MAX_BAGGAGE_ITEMS) {
        printf("Error: Baggage claim belt %d is full.\n", baggage_claim_belt->id);
        return;
    }

    baggage_item->claimed = true;
    baggage_claim_belt->bags_claimed[baggage_claim_belt->num_bags_claimed++] = baggage_item;
}

void print_baggage_items() {
    for (int i = 0; i < MAX_BAGGAGE_ITEMS; i++) {
        baggage_item *baggage_item = &baggage_items[i];
        printf("Baggage item %d: Destination %s, Checked in: %s, Claimed: %s\n",
            baggage_item->id, baggage_item->destination,
            baggage_item->checked_in ? "Yes" : "No",
            baggage_item->claimed ? "Yes" : "No");
    }
}

int main() {
    create_baggage_items();
    create_checkin_counters();
    create_baggage_claim_belts();

    // Check in some baggage items
    check_in_baggage(0, 0);
    check_in_baggage(1, 1);
    check_in_baggage(2, 2);

    // Claim some baggage items
    claim_baggage(0, 0);
    claim_baggage(1, 1);

    // Print the status of all baggage items
    print_baggage_items();

    return 0;
}