//Falcon-180B DATASET v1.0 Category: Mortgage Calculator ; Style: complex
#include <stdio.h>
#include <math.h>

#define PI 3.14159265358979323846

int main() {
    double principal, rate, term, payment, total_interest, monthly_interest;
    int choice;

    //initialize variables
    principal = 0;
    rate = 0;
    term = 0;
    payment = 0;
    total_interest = 0;
    monthly_interest = 0;

    printf("Welcome to the Mortgage Calculator!\n");
    printf("Please enter the principal amount: ");
    scanf("%lf", &principal);

    printf("Please enter the interest rate (in percentage): ");
    scanf("%lf", &rate);

    printf("Please enter the term of the mortgage (in years): ");
    scanf("%d", &term);

    payment = principal * rate / (1 - pow((1 + rate), -term * 12)) * 12;
    total_interest = payment * term * 12 - principal;
    monthly_interest = payment - (principal / term * 12);

    printf("\nYour monthly payment will be $%.2lf\n", payment);
    printf("Total interest paid over the life of the mortgage: $%.2lf\n", total_interest);
    printf("Monthly interest paid: $%.2lf\n", monthly_interest);

    printf("\nWould you like to see an amortization schedule? (y/n): ");
    scanf(" %c", &choice);

    if (choice == 'y' || choice == 'Y') {
        int month, remaining_principal;

        printf("\nAmortization Schedule:\n");
        printf("Month\tPayment\tInterest\tPrincipal\tRemaining Principal\n");

        for (month = 1; month <= term * 12; month++) {
            remaining_principal = principal - (monthly_interest * (month - 1));

            if (remaining_principal <= 0) {
                printf("%d\t$%.2lf\t$%.2lf\t$%.2lf\t$0.00\n", month, payment, monthly_interest, monthly_interest);
            } else {
                printf("%d\t$%.2lf\t$%.2lf\t$%.2lf\t$%.2lf\n", month, payment, monthly_interest, monthly_interest + (remaining_principal / (term * 12)), remaining_principal);
            }
        }
    }

    return 0;
}