//GPT-4o-mini DATASET v1.0 Category: Subnet Calculator ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Function to calculate the subnet mask
void calculateSubnetMask(int subnet_bits, char* subnet_mask) {
    unsigned int mask = (0xFFFFFFFF << (32 - subnet_bits)) & 0xFFFFFFFF;
    sprintf(subnet_mask, "%d.%d.%d.%d", (mask >> 24) & 0xFF, (mask >> 16) & 0xFF,
            (mask >> 8) & 0xFF, mask & 0xFF);
}

// Function to calculate the number of IP addresses
void calculateIPAddresses(int subnet_bits, int* total_ips, int* usable_ips) {
    *total_ips = pow(2, 32 - subnet_bits);
    *usable_ips = *total_ips - 2; // Subtracting network and broadcast addresses
}

// Function to calculate the network and broadcast addresses
void calculateNetworkBroadcast(char* ip_address, int subnet_bits, char* network_address, char* broadcast_address) {
    unsigned int ip_parts[4];
    sscanf(ip_address, "%u.%u.%u.%u", &ip_parts[0], &ip_parts[1], &ip_parts[2], &ip_parts[3]);

    unsigned int network = (ip_parts[0] << 24) + (ip_parts[1] << 16) + (ip_parts[2] << 8) + ip_parts[3];
    unsigned int subnet_mask = (0xFFFFFFFF << (32 - subnet_bits)) & 0xFFFFFFFF;

    // Calculate network address
    unsigned int network_address_int = network & subnet_mask;
    sprintf(network_address, "%d.%d.%d.%d", (network_address_int >> 24) & 0xFF, 
            (network_address_int >> 16) & 0xFF, 
            (network_address_int >> 8) & 0xFF, 
            network_address_int & 0xFF);

    // Calculate broadcast address
    unsigned int broadcast_address_int = network_address_int | (~subnet_mask);
    sprintf(broadcast_address, "%d.%d.%d.%d", (broadcast_address_int >> 24) & 0xFF, 
            (broadcast_address_int >> 16) & 0xFF, 
            (broadcast_address_int >> 8) & 0xFF, 
            broadcast_address_int & 0xFF);
}

// Function to display subnet information
void displaySubnetInfo(char* ip_address, int subnet_bits) {
    char subnet_mask[16];
    calculateSubnetMask(subnet_bits, subnet_mask);
    
    int total_ips, usable_ips;
    calculateIPAddresses(subnet_bits, &total_ips, &usable_ips);
    
    char network_address[16], broadcast_address[16];
    calculateNetworkBroadcast(ip_address, subnet_bits, network_address, broadcast_address);
    
    printf("\n---------------------------------------------\n");
    printf("🚀 Subnet Information for IP: %s/%d\n", ip_address, subnet_bits);
    printf("🌐 Subnet Mask: %s\n", subnet_mask);
    printf("🔗 Total IP Addresses: %d\n", total_ips);
    printf("🛡️ Usable IP Addresses: %d\n", usable_ips);
    printf("🏠 Network Address: %s\n", network_address);
    printf("🌍 Broadcast Address: %s\n", broadcast_address);
    printf("---------------------------------------------\n");
}

int main() {
    char ip_address[16];
    int subnet_bits;

    printf("🎉 Welcome to the Ultimate C Subnet Calculator! 🎉\n");
    
    printf("Please enter an IP address (e.g. 192.168.1.1): ");
    scanf("%s", ip_address);
    
    printf("Now, enter the subnet bits (e.g. 24 for a /24 subnet): ");
    scanf("%d", &subnet_bits);
    
    if (subnet_bits < 0 || subnet_bits > 32) {
        printf("🚫 Invalid subnet bits! Please enter a value between 0 and 32.\n");
        return 1;
    }

    displaySubnetInfo(ip_address, subnet_bits);
    
    printf("🎊 Thank you for using the C Subnet Calculator! 🎊\n");

    return 0;
}