//Gemma-7B DATASET v1.0 Category: Pac-Man Game Clone ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 20

typedef struct Pacman {
    int x;
    int y;
    int direction;
} Pacman;

Pacman pacman;

void drawBoard() {
    for (int y = 0; y < BOARD_SIZE; y++) {
        for (int x = 0; x < BOARD_SIZE; x++) {
            if (x == pacman.x && y == pacman.y) {
                printf("O ");
            } else if (x == 0) {
                printf("| ");
            } else if (x == BOARD_SIZE - 1) {
                printf("| ");
            } else {
                printf("  ");
            }
        }
        printf("\n");
    }
}

void movePacman() {
    switch (pacman.direction) {
        case 0:
            pacman.x++;
            break;
        case 1:
            pacman.y++;
            break;
        case 2:
            pacman.x--;
            break;
        case 3:
            pacman.y--;
            break;
    }
}

int main() {
    pacman.x = 5;
    pacman.y = 5;
    pacman.direction = 0;

    time_t t = time(NULL);
    srand(t);

    while (1) {
        drawBoard();
        movePacman();

        if (time(NULL) - t >= 1) {
            t = time(NULL);
            pacman.direction = rand() % 4;
        }

        if (pacman.x == 0 || pacman.x == BOARD_SIZE - 1) {
            pacman.direction = (pacman.direction + 1) % 4;
        }

        if (pacman.y == 0 || pacman.y == BOARD_SIZE - 1) {
            pacman.direction = (pacman.direction + 1) % 4;
        }

        if (pacman.x == 10 && pacman.y == 10) {
            printf("You Win!");
            break;
        }
    }

    return 0;
}