//Falcon2-11B DATASET v1.0 Category: Graph Coloring Problem ; Style: real-life
#include<stdio.h>
#include<stdlib.h>

int main() {
    //Create a graph with n vertices and m edges
    int n = 5;
    int m = 10;
    int graph[n][n]; //Initialize the graph as an empty matrix

    //Add edges to the graph
    for (int i = 0; i < m; i++) {
        int a = rand() % n;
        int b = rand() % n;
        graph[a][b] = 1;
        graph[b][a] = 1; //Make the graph undirected
    }

    //Find a proper coloring of the graph
    int color[n]; //Initialize a 1D array to store the colors of each vertex
    int minColor = 1; //Initialize the minimum color value
    int numColors = 0; //Initialize the number of colors used
    while (numColors < n) {
        int uncoloredVertex = -1; //Initialize the uncolored vertex index
        for (int i = 0; i < n; i++) {
            if (color[i] == 0) {
                uncoloredVertex = i;
                break;
            }
        }
        if (uncoloredVertex == -1) {
            printf("Graph is already colored!\n");
            break;
        }

        //Find a proper color for the uncolored vertex
        for (int c = minColor; c < n; c++) {
            if (color[uncoloredVertex]!= c) {
                color[uncoloredVertex] = c;
                numColors++;
                int numAdjVertices = 0; //Initialize the number of adjacent vertices
                for (int i = 0; i < n; i++) {
                    if (graph[uncoloredVertex][i] == 1 && color[i] == 0) {
                        color[i] = c;
                        numAdjVertices++;
                    }
                }
                if (numAdjVertices == n - 1) {
                    printf("Uncolored vertex %d colored with color %d\n", uncoloredVertex + 1, c + 1);
                    minColor = c + 1; //Update the minimum color value
                    break;
                }
            }
        }
    }

    //Output the coloring of the graph
    for (int i = 0; i < n; i++) {
        printf("Vertex %d is colored %d\n", i + 1, color[i] + 1);
    }

    return 0;
}