//GEMINI-pro DATASET v1.0 Category: Scientific Calculator Implementation ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main() {
    // Define the main menu options
    char options[] = {'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '+', '-', '*', '/', '%', '^', 'q'};
    char option;

    // Define the function prototypes
    double add(double a, double b);
    double subtract(double a, double b);
    double multiply(double a, double b);
    double divide(double a, double b);
    double modulus(double a, double b);
    double power(double a, double b);

    // Define the main loop
    while (1) {
        // Display the main menu
        printf("--------------------------------------------------\n");
        printf("Scientific Calculator\n");
        printf("--------------------------------------------------\n");
        printf("1. Add\n");
        printf("2. Subtract\n");
        printf("3. Multiply\n");
        printf("4. Divide\n");
        printf("5. Modulus\n");
        printf("6. Power\n");
        printf("7. Square root\n");
        printf("8. Cube root\n");
        printf("9. Sine\n");
        printf("0. Cosine\n");
        printf("+ Tangent\n");
        printf("- Inverse sine\n");
        printf("* Inverse cosine\n");
        printf("/ Inverse tangent\n");
        printf("%% Natural logarithm\n");
        printf("^ Logarithm (base 10)\n");
        printf("q. Quit\n");
        printf("--------------------------------------------------\n");
        printf("Enter your choice: ");

        // Get the user's choice
        scanf(" %c", &option);

        // Check if the user wants to quit
        if (option == 'q') {
            break;
        }

        // Check if the user entered a valid option
        int valid = 0;
        for (int i = 0; i < sizeof(options); i++) {
            if (option == options[i]) {
                valid = 1;
                break;
            }
        }

        if (!valid) {
            printf("Invalid choice. Please try again.\n");
            continue;
        }

        // Get the user's input
        double a, b;
        printf("Enter the first number: ");
        scanf(" %lf", &a);
        printf("Enter the second number: ");
        scanf(" %lf", &b);

        // Perform the calculation
        double result;
        switch (option) {
            case '1':
                result = add(a, b);
                break;
            case '2':
                result = subtract(a, b);
                break;
            case '3':
                result = multiply(a, b);
                break;
            case '4':
                if (b == 0) {
                    printf("Division by zero is undefined.\n");
                    continue;
                }
                result = divide(a, b);
                break;
            case '5':
                if (b == 0) {
                    printf("Modulus by zero is undefined.\n");
                    continue;
                }
                result = modulus(a, b);
                break;
            case '6':
                result = power(a, b);
                break;
            case '7':
                if (a < 0) {
                    printf("Square root of a negative number is undefined.\n");
                    continue;
                }
                result = sqrt(a);
                break;
            case '8':
                if (a < 0) {
                    printf("Cube root of a negative number is undefined.\n");
                    continue;
                }
                result = cbrt(a);
                break;
            case '9':
                result = sin(a);
                break;
            case '0':
                result = cos(a);
                break;
            case '+':
                result = tan(a);
                break;
            case '-':
                result = asin(a);
                break;
            case '*':
                result = acos(a);
                break;
            case '/':
                result = atan(a);
                break;
            case '%':
                result = log(a);
                break;
            case '^':
                result = log10(a);
                break;
        }

        // Display the result
        printf("Result: %lf\n", result);
    }

    return 0;
}

// Define the function to add two numbers
double add(double a, double b) {
    return a + b;
}

// Define the function to subtract two numbers
double subtract(double a, double b) {
    return a - b;
}

// Define the function to multiply two numbers
double multiply(double a, double b) {
    return a * b;
}

// Define the function to divide two numbers
double divide(double a, double b) {
    return a / b;
}

// Define the function to find the modulus of two numbers
double modulus(double a, double b) {
    return fmod(a, b);
}

// Define the function to find the power of two numbers
double power(double a, double b) {
    return pow(a, b);
}