//GEMINI-pro DATASET v1.0 Category: Color Code Converter ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the RGB color structure
typedef struct {
    unsigned char red;
    unsigned char green;
    unsigned char blue;
} RGB;

// Define the HSV color structure
typedef struct {
    float hue;
    float saturation;
    float value;
} HSV;

// Convert RGB to HSV
void RGBtoHSV(RGB rgb, HSV *hsv) {
    float min, max, delta;
    float r = rgb.red / 255.0;
    float g = rgb.green / 255.0;
    float b = rgb.blue / 255.0;
    
    min = fmin(r, fmin(g, b));
    max = fmax(r, fmax(g, b));
    delta = max - min;

    hsv->value = max;

    if (delta == 0) {
        hsv->hue = 0;
        hsv->saturation = 0;
    } else {
        if (max == r) {
            hsv->hue = (g - b) / delta;
        } else if (max == g) {
            hsv->hue = 2 + (b - r) / delta;
        } else {
            hsv->hue = 4 + (r - g) / delta;
        }

        hsv->hue *= 60;
        if (hsv->hue < 0) {
            hsv->hue += 360;
        }

        hsv->saturation = delta / max;
    }
}

// Convert HSV to RGB
void HSVtoRGB(HSV hsv, RGB *rgb) {
    float c = hsv.saturation * hsv.value;
    float h = hsv.hue / 60.0;
    float x = c * (1 - fabs(fmod(h, 2) - 1));
    float m = hsv.value - c;

    if (h >= 0 && h < 1) {
        rgb->red = (c + m) * 255;
        rgb->green = (x + m) * 255;
        rgb->blue = m * 255;
    } else if (h >= 1 && h < 2) {
        rgb->red = (x + m) * 255;
        rgb->green = (c + m) * 255;
        rgb->blue = m * 255;
    } else if (h >= 2 && h < 3) {
        rgb->red = m * 255;
        rgb->green = (c + m) * 255;
        rgb->blue = (x + m) * 255;
    } else if (h >= 3 && h < 4) {
        rgb->red = m * 255;
        rgb->green = (x + m) * 255;
        rgb->blue = (c + m) * 255;
    } else if (h >= 4 && h < 5) {
        rgb->red = (x + m) * 255;
        rgb->green = m * 255;
        rgb->blue = (c + m) * 255;
    } else if (h >= 5 && h < 6) {
        rgb->red = (c + m) * 255;
        rgb->green = m * 255;
        rgb->blue = (x + m) * 255;
    }
}

// Print the RGB color in hexadecimal format
void printRGB(RGB rgb) {
    printf("#%02x%02x%02x\n", rgb.red, rgb.green, rgb.blue);
}

// Print the HSV color in hexadecimal format
void printHSV(HSV hsv) {
    printf("H: %0.2f, S: %0.2f, V: %0.2f\n", hsv.hue, hsv.saturation, hsv.value);
}

// Get the RGB color from the user
RGB getRGB() {
    RGB rgb;
    printf("Enter the RGB color (e.g. 255 128 0): ");
    scanf("%hhu %hhu %hhu", &rgb.red, &rgb.green, &rgb.blue);
    return rgb;
}

// Get the HSV color from the user
HSV getHSV() {
    HSV hsv;
    printf("Enter the HSV color (e.g. 0.0 1.0 0.5): ");
    scanf("%f %f %f", &hsv.hue, &hsv.saturation, &hsv.value);
    return hsv;
}

// Main function
int main() {
    int choice;

    printf("1. Convert RGB to HSV\n");
    printf("2. Convert HSV to RGB\n");
    printf("Choice: ");
    scanf("%d", &choice);

    switch (choice) {
        case 1: {
            RGB rgb = getRGB();
            HSV hsv;

            RGBtoHSV(rgb, &hsv);
            printf("HSV: ");
            printHSV(hsv);
            break;
        }

        case 2: {
            HSV hsv = getHSV();
            RGB rgb;

            HSVtoRGB(hsv, &rgb);
            printf("RGB: ");
            printRGB(rgb);
            break;
        }

        default:
            printf("Invalid choice\n");
            break;
    }

    return 0;
}