//GPT-4o-mini DATASET v1.0 Category: Checkers Game ; Style: careful
#include <stdio.h>
#include <stdlib.h>

#define BOARD_SIZE 8

typedef struct {
    char board[BOARD_SIZE][BOARD_SIZE];
    char currentPlayer;
} GameState;

void initializeBoard(GameState *game) {
    // Initialize board with pieces
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            if ((i + j) % 2 != 0) { // Only fill the dark squares
                if (i < 3) {
                    game->board[i][j] = 'B'; // Black pieces
                } else if (i > 4) {
                    game->board[i][j] = 'R'; // Red pieces
                } else {
                    game->board[i][j] = '.';
                }
            } else {
                game->board[i][j] = ' ';
            }
        }
    }
    game->currentPlayer = 'R'; // Red starts
}

void printBoard(const GameState *game) {
    printf("\n  A B C D E F G H\n");
    printf(" +----------------+\n");
    for (int i = 0; i < BOARD_SIZE; i++) {
        printf("%d| ", 8 - i);
        for (int j = 0; j < BOARD_SIZE; j++) {
            printf("%c ", game->board[i][j]);
        }
        printf("|\n");
    }
    printf(" +----------------+\n");
}

int isValidMove(GameState *game, int startX, int startY, int endX, int endY) {
    // Basic move validation
    if (endX < 0 || endX >= BOARD_SIZE || endY < 0 || endY >= BOARD_SIZE) return 0;
    if (game->board[endX][endY] != '.') return 0; // Target square is occupied
    if ((startX + startY) % 2 == 0 || (endX + endY) % 2 == 0) return 0; // Must move on dark squares

    int direction = game->currentPlayer == 'R' ? 1 : -1; // Direction based on player
    
    // Normal move (1 square)
    if (startX + direction == endX && (startY + 1 == endY || startY - 1 == endY)) {
        return 1;
    }

    // Jump move (2 squares)
    if (startX + 2 * direction == endX && (startY + 2 == endY || startY - 2 == endY)) {
        int middleX = (startX + endX) / 2;
        int middleY = (startY + endY) / 2;
        if ((game->currentPlayer == 'R' && game->board[middleX][middleY] == 'B') || 
            (game->currentPlayer == 'B' && game->board[middleX][middleY] == 'R')) {
            return 2; // valid jump
        }
    }

    return 0;
}

void makeMove(GameState *game, int startX, int startY, int endX, int endY) {
    // Move the piece
    game->board[endX][endY] = game->board[startX][startY];
    game->board[startX][startY] = '.';

    // Check for jump
    if (abs(startX - endX) == 2) {
        int middleX = (startX + endX) / 2;
        int middleY = (startY + endY) / 2;
        game->board[middleX][middleY] = '.'; // Remove jumped piece
    }
}

int main() {
    GameState game;
    initializeBoard(&game);
    
    int startX, startY, endX, endY;
    char input[5];

    while (1) {
        printBoard(&game);
        printf("Player %c, enter your move (e.g., E3 E4): ", game.currentPlayer);
        fgets(input, sizeof(input), stdin);
        sscanf(input, "%c%d %c%d", &input[0], &startX, &input[2], &endX);
        
        startY = input[0] - 'A';
        endY = input[2] - 'A';
        startX = 8 - startX; // Convert to array index
        endX = 8 - endX; // Convert to array index

        if (isValidMove(&game, startX, startY, endX, endY)) {
            makeMove(&game, startX, startY, endX, endY);
            game.currentPlayer = (game.currentPlayer == 'R') ? 'B' : 'R'; // Switch player
        } else {
            printf("Invalid move. Try again.\n");
        }
    }

    return 0;
}