//GPT-4o-mini DATASET v1.0 Category: Breakout Game Clone ; Style: detailed
#include <ncurses.h>
#include <stdlib.h>
#include <time.h>

#define BRICK '#'
#define EMPTY ' '
#define PADDLE '='
#define BALL 'O'
#define BRICKS_ROWS 5
#define BRICKS_COLS 10

typedef struct {
    int x, y; // Position of the ball
    int dir_x, dir_y; // Direction of the ball
} Ball;

typedef struct {
    int paddle_pos;
} Paddle;

typedef struct {
    char bricks[BRICKS_ROWS][BRICKS_COLS];
} BrickField;

void initialize_bricks(BrickField *field) {
    for (int i = 0; i < BRICKS_ROWS; ++i) {
        for (int j = 0; j < BRICKS_COLS; ++j) {
            field->bricks[i][j] = BRICK;
        }
    }
}

void draw_bricks(BrickField *field) {
    for (int i = 0; i < BRICKS_ROWS; ++i) {
        for (int j = 0; j < BRICKS_COLS; ++j) {
            mvaddch(i + 1, j + 1, field->bricks[i][j]);
        }
    }
}

void draw_paddle(Paddle *paddle) {
    mvaddch(LINES - 1, paddle->paddle_pos, PADDLE);
    mvaddch(LINES - 1, paddle->paddle_pos + 1, PADDLE);
    mvaddch(LINES - 1, paddle->paddle_pos + 2, PADDLE);
}

void draw_ball(Ball *ball) {
    mvaddch(ball->y, ball->x, BALL);
}

void erase_ball(Ball *ball) {
    mvaddch(ball->y, ball->x, EMPTY);
}

int check_collision(Ball *ball, BrickField *field) {
    if (ball->y < BRICKS_ROWS + 1 && ball->x < BRICKS_COLS && ball->x >= 0) {
        if (field->bricks[ball->y - 1][ball->x] == BRICK) {
            field->bricks[ball->y - 1][ball->x] = EMPTY;
            return 1; // Collided with a brick
        }
    }
    return 0;
}

int main() {
    initscr(); // Start curses mode
    noecho(); // Don't echo user input
    cbreak(); // Disable line buffering
    keypad(stdscr, TRUE); // Enable special keys
    nodelay(stdscr, TRUE); // Make getch non-blocking
    curs_set(FALSE); // Hide the cursor

    srand(time(NULL));

    Ball ball = {5, 5, 1, 1};
    Paddle paddle = {5};
    BrickField field;
    initialize_bricks(&field);

    while (1) {
        clear();
        draw_bricks(&field);
        draw_paddle(&paddle);
        draw_ball(&ball);
        
        refresh();

        // Ball movement
        erase_ball(&ball);
        ball.x += ball.dir_x;
        ball.y += ball.dir_y;

        // Border collision (top and bottom)
        if (ball.y <= 0 || (ball.y == LINES - 1 && (ball.x >= paddle.paddle_pos && ball.x <= paddle.paddle_pos + 2))) {
            ball.dir_y *= -1; // Reverse direction
        }

        // Brick collision
        if (check_collision(&ball, &field)) {
            ball.dir_y *= -1; // Reverse direction
        }

        // Right and left wall collision
        if (ball.x <= 0 || ball.x >= COLS - 1) {
            ball.dir_x *= -1; // Reverse direction
        }

        // Paddle movement
        int ch = getch();
        switch (ch) {
            case KEY_LEFT:
                if (paddle.paddle_pos > 0) {
                    paddle.paddle_pos--;
                }
                break;
            case KEY_RIGHT:
                if (paddle.paddle_pos < COLS - 3) {
                    paddle.paddle_pos++;
                }
                break;
            case 'q':
                endwin(); // End curses mode
                return 0; // Quit game
        }

        // Delay for frame rate
        napms(50);
    }

    endwin(); // End curses mode
    return 0;
}