//GPT-4o-mini DATASET v1.0 Category: Game ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#define MAX_OBSTACLES 5
#define MAX_CREDITS 10

typedef enum { FALSE, TRUE } bool;

typedef struct {
    int position;
    int credits;
} Player;

typedef struct {
    int position;
    bool active;
} Obstacle;

void initialize_player(Player *player) {
    player->position = 0;
    player->credits = 0;
}

void initialize_obstacles(Obstacle obstacles[], int count) {
    for (int i = 0; i < count; i++) {
        obstacles[i].position = -1;
        obstacles[i].active = FALSE;
    }
}

void spawn_obstacle(Obstacle obstacles[], int count) {
    for (int i = 0; i < count; i++) {
        if (!obstacles[i].active) {
            obstacles[i].position = rand() % 20 + 1; // Random position [1-20]
            obstacles[i].active = TRUE;
            break;
        }
    }
}

void move_obstacles(Obstacle obstacles[], int count) {
    for (int i = 0; i < count; i++) {
        if (obstacles[i].active) {
            obstacles[i].position -= 1;
            if (obstacles[i].position <= 0) {
                obstacles[i].active = FALSE; // Reset obstacle
                obstacles[i].position = -1;
            }
        }
    }
}

void display(Player player, Obstacle obstacles[], int count) {
    system("clear");
    
    printf("==== Neon Runner ====\n");
    printf("Credits: %d\n", player.credits);
    printf("=====================\n");
    
    for (int i = 0; i < 20; i++) {
        bool printed = FALSE;
        if (i == player.position) {
            printf("P "); // Player
            printed = TRUE;
        }
        for (int j = 0; j < count; j++) {
            if (obstacles[j].active && obstacles[j].position == i) {
                printf("X "); // Obstacle
                printed = TRUE;
            }
        }
        if (!printed) {
            printf(". "); // Empty space
        }
    }
    printf("\n=====================\n");
}

bool check_collision(Player player, Obstacle obstacles[], int count) {
    for (int i = 0; i < count; i++) {
        if (obstacles[i].active && obstacles[i].position == player.position) {
            return TRUE; // Collision detected
        }
    }
    return FALSE;
}

void collect_credit(Player *player) {
    if (rand() % 5 == 0) { // 20% chance to collect credit
        player->credits++;
    }
}

void run_game() {
    Player player;
    Obstacle obstacles[MAX_OBSTACLES];
    int game_speed = 1;
    
    initialize_player(&player);
    initialize_obstacles(obstacles, MAX_OBSTACLES);
    
    srand(time(NULL));
    
    while (TRUE) {
        spawn_obstacle(obstacles, MAX_OBSTACLES);
        
        display(player, obstacles, MAX_OBSTACLES);

        if (check_collision(player, obstacles, MAX_OBSTACLES)) {
            printf("You collided with an obstacle! Game Over.\n");
            break;
        }
        
        collect_credit(&player);
        
        printf("Move (L for left, R for right): ");
        char move;
        scanf(" %c", &move);
        
        if (move == 'L' && player.position > 0) {
            player.position--;
        } else if (move == 'R' && player.position < 19) {
            player.position++;
        }
        
        move_obstacles(obstacles, MAX_OBSTACLES);
        
        sleep(game_speed);
    }
}

int main() {
    run_game();
    return 0;
}