//GEMINI-pro DATASET v1.0 Category: Checkers Game ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8

typedef enum {
    EMPTY,
    WHITE,
    BLACK,
    KING
} piece_t;

typedef struct {
    piece_t board[BOARD_SIZE][BOARD_SIZE];
    int white_count;
    int black_count;
    int turn;
} game_t;

void init_game(game_t *game) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            if (i < 3 && (i + j) % 2 == 0) {
                game->board[i][j] = WHITE;
            } else if (i > 4 && (i + j) % 2 == 0) {
                game->board[i][j] = BLACK;
            } else {
                game->board[i][j] = EMPTY;
            }
        }
    }
    game->white_count = 12;
    game->black_count = 12;
    game->turn = WHITE;
}

void print_board(game_t *game) {
    printf("  a b c d e f g h\n");
    for (int i = 0; i < BOARD_SIZE; i++) {
        printf("%d ", i + 1);
        for (int j = 0; j < BOARD_SIZE; j++) {
            switch (game->board[i][j]) {
                case EMPTY:
                    printf(" ");
                    break;
                case WHITE:
                    printf("w");
                    break;
                case BLACK:
                    printf("b");
                    break;
                case KING:
                    printf("k");
                    break;
            }
        }
        printf("\n");
    }
}

int is_valid_move(game_t *game, int from_x, int from_y, int to_x, int to_y) {
    // Check if the move is within the bounds of the board
    if (from_x < 0 || from_x >= BOARD_SIZE || to_x < 0 || to_x >= BOARD_SIZE || from_y < 0 || from_y >= BOARD_SIZE || to_y < 0 || to_y >= BOARD_SIZE) {
        return 0;
    }

    // Check if the from and to squares are the same
    if (from_x == to_x && from_y == to_y) {
        return 0;
    }

    // Check if the from square is empty
    if (game->board[from_x][from_y] == EMPTY) {
        return 0;
    }

    // Check if the to square is empty
    if (game->board[to_x][to_y] != EMPTY) {
        return 0;
    }

    // Check if the move is diagonal
    if (abs(to_x - from_x) != abs(to_y - from_y)) {
        return 0;
    }

    // Check if the move is forward
    if (game->turn == WHITE && to_x < from_x) {
        return 0;
    } else if (game->turn == BLACK && to_x > from_x) {
        return 0;
    }

    // Check if the move is a jump
    if (abs(to_x - from_x) == 2) {
        int jump_x = (to_x + from_x) / 2;
        int jump_y = (to_y + from_y) / 2;
        if (game->board[jump_x][jump_y] != (game->turn == WHITE ? BLACK : WHITE)) {
            return 0;
        }
    }

    return 1;
}

void make_move(game_t *game, int from_x, int from_y, int to_x, int to_y) {
    game->board[to_x][to_y] = game->board[from_x][from_y];
    game->board[from_x][from_y] = EMPTY;

    // Check if the move was a jump
    if (abs(to_x - from_x) == 2) {
        int jump_x = (to_x + from_x) / 2;
        int jump_y = (to_y + from_y) / 2;
        game->board[jump_x][jump_y] = EMPTY;

        if (game->turn == WHITE) {
            game->black_count--;
        } else {
            game->white_count--;
        }
    }

    // Check if the piece reached the other side of the board
    if ((game->turn == WHITE && to_x == 0) || (game->turn == BLACK && to_x == BOARD_SIZE - 1)) {
        game->board[to_x][to_y] = KING;
    }

    // Switch turns
    game->turn = (game->turn == WHITE ? BLACK : WHITE);
}

int is_game_over(game_t *game) {
    return game->white_count == 0 || game->black_count == 0;
}

int main() {
    game_t game;
    init_game(&game);

    while (!is_game_over(&game)) {
        print_board(&game);

        char from_square[3];
        char to_square[3];

        printf("Enter the from square: ");
        scanf("%s", from_square);

        printf("Enter the to square: ");
        scanf("%s", to_square);

        int from_x = from_square[0] - 'a';
        int from_y = from_square[1] - '1';
        int to_x = to_square[0] - 'a';
        int to_y = to_square[1] - '1';

        if (is_valid_move(&game, from_x, from_y, to_x, to_y)) {
            make_move(&game, from_x, from_y, to_x, to_y);
        } else {
            printf("Invalid move\n");
        }
    }

    print_board(&game);

    if (game.white_count == 0) {
        printf("Black wins!\n");
    } else {
        printf("White wins!\n");
    }

    return 0;
}