//Gemma-7B DATASET v1.0 Category: Bingo Simulator ; Style: scientific
#include <stdio.h>
#include <stdlib.h>

#define MAX_NUM 25

int main() {
  int board[MAX_NUM] = {0};
  int num_calls = 0;
  int won = 0;

  // Generate a random number for each call
  srand(time(NULL));

  // Fill the board randomly
  for (int i = 0; i < MAX_NUM; i++) {
    board[i] = rand() % MAX_NUM + 1;
  }

  // Call numbers repeatedly
  while (!won) {
    int call_num = rand() % MAX_NUM + 1;

    // Mark the number as called
    board[call_num - 1] = -1;

    // Increment the number of calls
    num_calls++;

    // Check if the player has won
    won = check_win(board, num_calls);
  }

  // Print the winning numbers
  printf("The winning numbers are:");
  for (int i = 0; i < MAX_NUM; i++) {
    if (board[i] == -1) {
      printf(" %d", board[i] );
    }
  }

  printf("\n");

  // Print the number of calls
  printf("Number of calls: %d", num_calls);

  return 0;
}

int check_win(int *board, int num_calls) {
  // Check rows
  for (int i = 0; i < MAX_NUM; i++) {
    if (board[i] == -1 && board[i + 5] == -1 && board[i + 10] == -1) {
      return 1;
    }
  }

  // Check columns
  for (int i = 0; i < MAX_NUM; i++) {
    if (board[i] == -1 && board[i + 1] == -1 && board[i + 2] == -1) {
      return 1;
    }
  }

  // Check diagonals
  if (board[0] == -1 && board[6] == -1 && board[12] == -1) {
    return 1;
  }
  if (board[4] == -1 && board[8] == -1 && board[16] == -1) {
    return 1;
  }

  // No win
  return 0;
}