//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGGAGES 100
#define NUM_DESTINATIONS 10
#define NUM_PLANES 5
#define MAX_PLANE_CAPACITY 50
#define MAX_BAGGAGE_SIZE 10

typedef struct {
    int destination;
    int size;
} Baggage;

typedef struct {
    int capacity;
    int num_baggage;
} Plane;

Baggage baggages[NUM_BAGGAGES];
Plane planes[NUM_PLANES];
int destinations[NUM_DESTINATIONS];

void generate_baggages() {
    int i;
    for (i = 0; i < NUM_BAGGAGES; i++) {
        baggages[i].destination = rand() % NUM_DESTINATIONS;
        baggages[i].size = rand() % MAX_BAGGAGE_SIZE + 1;
    }
}

void generate_planes() {
    int i;
    for (i = 0; i < NUM_PLANES; i++) {
        planes[i].capacity = rand() % MAX_PLANE_CAPACITY + 1;
        planes[i].num_baggage = 0;
    }
}

void assign_baggages_to_planes() {
    int i, j;
    for (i = 0; i < NUM_BAGGAGES; i++) {
        for (j = 0; j < NUM_PLANES; j++) {
            if (planes[j].num_baggage < planes[j].capacity &&
                destinations[baggages[i].destination] == destinations[planes[j].num_baggage]) {
                planes[j].num_baggage++;
                break;
            }
        }
    }
}

void print_baggages() {
    int i;
    for (i = 0; i < NUM_BAGGAGES; i++) {
        printf("Baggage %d has destination %d and size %d\n", i, baggages[i].destination, baggages[i].size);
    }
}

void print_planes() {
    int i;
    for (i = 0; i < NUM_PLANES; i++) {
        printf("Plane %d has capacity %d and %d baggages:\n", i, planes[i].capacity, planes[i].num_baggage);
        int j;
        for (j = 0; j < planes[i].num_baggage; j++) {
            printf("  Baggage %d\n", j);
        }
    }
}

int main() {
    srand(time(NULL));

    generate_baggages();
    generate_planes();
    assign_baggages_to_planes();

    printf("Unassigned baggages:\n");
    print_baggages();

    printf("\nAssigned baggages:\n");
    print_planes();

    return 0;
}