//GEMINI-pro DATASET v1.0 Category: User Input Sanitizer ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>

#define MAX_CLIENTS 10
#define BUF_SIZE 1024

// Function to sanitize input
int sanitize_input(char *input) {
    // Check for null input
    if (input == NULL) {
        return -1;
    }

    // Check for empty input
    if (strlen(input) == 0) {
        return -1;
    }

    // Check for invalid characters
    for (int i = 0; i < strlen(input); i++) {
        if (!isalnum(input[i]) && input[i] != ' ' && input[i] != '-') {
            return -1;
        }
    }

    // Check for leading or trailing spaces
    if (isspace(input[0]) || isspace(input[strlen(input) - 1])) {
        return -1;
    }

    // Check for consecutive spaces
    for (int i = 0; i < strlen(input) - 1; i++) {
        if (isspace(input[i]) && isspace(input[i + 1])) {
            return -1;
        }
    }

    // Check for invalid characters at the beginning or end of the string
    if (!isalpha(input[0]) && input[0] != '-') {
        return -1;
    }

    if (!isalnum(input[strlen(input) - 1])) {
        return -1;
    }

    // Check for leading or trailing hyphens
    if (input[0] == '-' || input[strlen(input) - 1] == '-') {
        return -1;
    }

    // Check for consecutive hyphens
    for (int i = 0; i < strlen(input) - 1; i++) {
        if (input[i] == '-' && input[i + 1] == '-') {
            return -1;
        }
    }

    // Return 1 if the input is valid
    return 1;
}

// Function to handle client requests
void handle_client(int client_fd) {
    // Buffer to store the client's input
    char buf[BUF_SIZE];

    // Receive the client's input
    int recv_bytes = recv(client_fd, buf, BUF_SIZE, 0);

    // Check if the client has closed the connection
    if (recv_bytes == 0) {
        close(client_fd);
        return;
    }

    // Check if there was an error receiving the input
    if (recv_bytes == -1) {
        perror("recv");
        close(client_fd);
        return;
    }

    // Null-terminate the input
    buf[recv_bytes] = '\0';

    // Sanitize the input
    int is_valid = sanitize_input(buf);

    // Send the response to the client
    if (is_valid == 1) {
        send(client_fd, "Input is valid", strlen("Input is valid"), 0);
    } else {
        send(client_fd, "Input is not valid", strlen("Input is not valid"), 0);
    }

    // Close the client's connection
    close(client_fd);
}

int main() {
    // Socket descriptor
    int sockfd;

    // Structure to store the server's address
    struct sockaddr_in servaddr;

    // Create the socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Initialize the server's address
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = INADDR_ANY;
    servaddr.sin_port = htons(8080);

    // Bind the socket to the server's address
    if (bind(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) == -1) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sockfd, MAX_CLIENTS) == -1) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Main loop
    while (1) {
        // Accept incoming connections
        int client_fd = accept(sockfd, NULL, NULL);

        if (client_fd == -1) {
            perror("accept");
            continue;
        }

        // Handle client requests asynchronously
        pid_t pid = fork();

        if (pid == -1) {
            perror("fork");
            close(client_fd);
            continue;
        }

        if (pid == 0) {
            // Child process
            handle_client(client_fd);
            exit(EXIT_SUCCESS);
        }

        // Parent process
        close(client_fd);
    }

    // Close the socket
    close(sockfd);

    return 0;
}