//Code Llama-13B DATASET v1.0 Category: Image to ASCII art converter ; Style: minimalist
/*
* Image to ASCII Art Converter
*
* Usage: ./image_to_ascii_art <image_file>
*
* Converts an image file to ASCII art and prints it to the terminal.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Function to convert an image to ASCII art
void convert_to_ascii_art(const char *image_file) {
    // Open the image file
    FILE *image = fopen(image_file, "r");
    if (image == NULL) {
        fprintf(stderr, "Error: Could not open image file %s\n", image_file);
        exit(1);
    }

    // Read the image dimensions
    int width, height;
    fscanf(image, "%d %d", &width, &height);

    // Allocate memory for the image data
    unsigned char *image_data = malloc(width * height * 3);
    if (image_data == NULL) {
        fprintf(stderr, "Error: Could not allocate memory for image data\n");
        exit(1);
    }

    // Read the image data
    fread(image_data, 1, width * height * 3, image);

    // Close the image file
    fclose(image);

    // Convert the image data to ASCII art
    char *ascii_art = malloc(width * height * 2);
    if (ascii_art == NULL) {
        fprintf(stderr, "Error: Could not allocate memory for ASCII art\n");
        exit(1);
    }

    for (int i = 0; i < width * height; i++) {
        int rgb = (image_data[i * 3] + image_data[i * 3 + 1] + image_data[i * 3 + 2]) / 3;
        ascii_art[i * 2] = ".,-~:;=!*#$@"[rgb / 25];
        ascii_art[i * 2 + 1] = '\0';
    }

    // Print the ASCII art to the terminal
    printf("%s\n", ascii_art);

    // Free the memory
    free(image_data);
    free(ascii_art);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <image_file>\n", argv[0]);
        exit(1);
    }

    convert_to_ascii_art(argv[1]);

    return 0;
}